﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Helpers;
using System.Web.Mvc;
using System.Web.UI;
using System.Web.UI.WebControls;
using WebGridNew1.Models;

namespace WebGridNew1.Controllers
{
    public class MeetingController : Controller
    {
        // GET: Meeting
        public ActionResult Index()
        {
            DataAccessLayer objDAL = new DataAccessLayer();
            MeetingVM objMeetingVM = new MeetingVM();
            objMeetingVM.MeetingsObj = new List<Meeting>();
            objMeetingVM.MeetingsObj = objDAL.MeetingMaster.ToList<Meeting>();


            return View(objMeetingVM);
        }

        [HttpPost]
        public ActionResult Export()
        {
            DataAccessLayer objDAL = new DataAccessLayer();
            MeetingVM objMeetingVM = new MeetingVM();
            objMeetingVM.MeetingsObj = new List<Meeting>();
            objMeetingVM.MeetingsObj = objDAL.MeetingMaster.ToList<Meeting>();



            WebGrid grid = new WebGrid(source: objMeetingVM.MeetingsObj, canPage: false, canSort: false);

            string gridData = grid.GetHtml(
                columns: grid.Columns(
                        grid.Column("MeetingID", "Meeting ID"),
                        grid.Column("MeetingName", "Name of Meeting"),
                        grid.Column("Format", "Name of Fomat"),
                        grid.Column("Location", "Location at")
                        )
                    ).ToString();

            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=MeetingDetails.xls");
            Response.ContentType = "application/excel";
            Response.Write(gridData);
            Response.End();



            return View(objMeetingVM);
        }

        [HttpPost]
        public ActionResult ExportHeade()
        {
            DataAccessLayer objDAL = new DataAccessLayer();
            MeetingVM objMeetingVM = new MeetingVM();
            objMeetingVM.MeetingsObj = new List<Meeting>();
            objMeetingVM.MeetingsObj = objDAL.MeetingMaster.ToList<Meeting>();
            GridView obj = new GridView();
            obj.DataSource = objMeetingVM.MeetingsObj;
            obj.DataBind();
            Response.AddHeader("content-disposition", string.Format("attachment; filename={0}", "Meeting.xls"));
            Response.ContentType = "application/ms-excel";
            System.IO.StringWriter sw = new StringWriter();
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            obj.HeaderRow.Style.Add("background-color", "#FFFFFF");
            for (int i = 0; i < obj.HeaderRow.Cells.Count; i++)
            {
                obj.HeaderRow.Cells[i].Style.Add("background-color", "#507CD1");
            }
            int j = 1;
            foreach (GridViewRow gvrow in obj.Rows)
            {
                gvrow.BackColor = Color.White;
                if (j <= obj.Rows.Count)
                {
                    if (j % 2 != 0)
                    {
                        for (int k = 0; k < gvrow.Cells.Count; k++)
                        {
                            gvrow.Cells[k].Style.Add("background-color", "#EFF3FB");
                        }
                    }
                }
                j++;
            }
            obj.RenderControl(htw);
            Response.Write(sw.ToString());
            Response.End();

            return View(objMeetingVM);

        }

       [HttpPost]
        public ActionResult DeleteMeeting(Meeting objMeeting)
        {
            MeetingVM obj = new MeetingVM();
            DataAccessLayer objDAL = new DataAccessLayer();
          objDAL.MeetingMaster.RemoveRange(objDAL.MeetingMaster.Where(c => c.MeetingId == objMeeting.MeetingId));
            objDAL.SaveChanges();
            obj.MeetingsObj = objDAL.MeetingMaster.ToList<Meeting>();


            return View(obj);
        }
    }
}